<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Core_Exception_SchemaNotFound
    extends MageQL_Core_Exception
    implements ClientAware {
    public function __construct($schemaName) {
        parent::__construct(sprintf("Schema '%s' was not found.", $schemaName), 1001);
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "schema";
    }
}
