<?php

declare(strict_types=1);

/**
 * @method MageQL_Core_Block_Graphiql setSchemaName(string $schemaName)
 * @method string getSchemaName()
 */
class MageQL_Core_Block_Graphiql extends Mage_Core_Block_Template {
    protected function _construct() {
        parent::_construct();

        $this->setTemplate("mageql/graphiql.phtml");
    }

    public function getGraphQlPath() {
        return Mage::getUrl(implode("/", array_filter([MageQL_Core_Router_GraphQL::GRAPHQL_PATH, $this->getSchemaName()])));
    }
}
