<?php

declare(strict_types=1);

namespace MageQL\Core;

use Throwable;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use PHPUnit\Framework\TestCase;
use Spatie\Snapshots\MatchesSnapshots;

use function MageQL\sanitizeGraphqlName;

class InfoTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function onNotSuccessfulTest(Throwable $e): void {
        MagentoManager::logQueries();

        throw $e;
    }

    public function testSanitizeGraphqlName(): void {
        $this->assertEquals(sanitizeGraphqlName("ABC123"), "ABC123");
        $this->assertEquals(sanitizeGraphqlName("Buy&Transfer"), "Buy_Transfer");
        $this->assertEquals(sanitizeGraphqlName("0"), "_");
        $this->assertEquals(sanitizeGraphqlName("012345"), "_12345");
    }

    public function testInfoUrl(): void {
        $resp = MagentoManager::runRequest(new Request("GET /graphql?query=query{info{baseUrl}}"));

        $this->assertMatchesJsonSnapshot($resp->getBody());
        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));
    }

    public function testInfoAll(): void {
        $resp = MagentoManager::runRequest(new Request("POST /graphql", [
            "Content-Type" => "application/graphql",
        ], 'query {
            info {
                baseCurrencyCode
                baseUrl
                currencyCodes
                defaultCountry {
                    code
                    name
                }
                defaultDescription
                defaultTitle
                locale
                name
                titlePrefix
                titleSuffix
                countries {
                    code
                    name
                }
            }
        }'));

        $this->assertMatchesJsonSnapshot($resp->getBody());
        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));
    }
}
