<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Core_InvalidCountryCodeException
    extends Exception
    implements ClientAware {
    public function __construct(string $countryCode) {
        parent::__construct(sprintf(
            "The country code '%s' is invalid and cannot be assigned to an address.",
            $countryCode
        ));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql";
    }
}
