<?php

declare(strict_types=1);

namespace MageQL\Core;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use PHPUnit\Framework\TestCase;
use Spatie\Snapshots\MatchesSnapshots;

class GraphiqlTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function testGet(): void {
        $resp = MagentoManager::runRequest(new Request("GET /graphiql"));

        // Content differs when running in CI.
        // $this->assertMatchesHtmlSnapshot($resp->getBody());

        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("text/html; charset=UTF-8", $resp->getHeader("Content-Type"));
    }
}
