<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;
use GraphQL\Type\Definition\Type;

/**
 * @template TypeDefinition as array
 */
abstract class TypedBuilder {
    /**
     * @var string
     */
    protected $description;
    /**
     * @var string
     */
    protected $type;

    public function __construct(string $typeName, string $description) {
        $this->type = $typeName;
        $this->description = $description;
    }

    public function getDescription(): ?string {
        return $this->description;
    }

    public function getType(): string {
        return $this->type;
    }

    /**
     * @return TypeDefinition
     */
    abstract function createInstance(
        Registry $registry,
        string $typeName
    ): array;
}
