<?php

declare(strict_types=1);

namespace MageQL\Type;

use function array_key_exists;

use MageQL\Registry;
use GraphQL\Type\Definition\Type;

/**
 * @template T
 * @psalm-type ArgumentDefinition array{
 *   name: string,
 *   description: ?string,
 *   type: ?Type,
 *   defaultValue?: mixed,
 * }
 * @extends TypedBuilder<ArgumentDefinition>
 */
class ArgumentBuilder extends TypedBuilder {
    /**
     * @var ?T
     */
    protected $defaultValue = null;

    /**
     * @param ?T $defaultValue
     */
    public function __construct(
        string $typeName,
        string $description,
        $defaultValue = null
    ) {
        parent::__construct($typeName, $description);

        $this->defaultValue = $defaultValue;
    }

    /**
     * @param ?T $value
     */
    public function setDefaultValue($value): self {
        $this->defaultValue = $value;

        return $this;
    }

    /**
     * @return ArgumentDefinition
     */
    public function createInstance(
        Registry $registry,
        string $typeName
    ): array {
        $data = [
            "name" => $typeName,
            "description" => $this->description,
            "type" => $registry->getType($this->type),
        ];

        if($this->defaultValue !== null) {
            $data["defaultValue"] = $this->defaultValue;
        }

        return $data;
    }
}
