<?php

declare(strict_types=1);

namespace MageQL;

use Exception;

class SessionFailedException extends ClientException {
    public function __construct(Exception $e) {
        parent::__construct("Session failed to reinitialize", 0, $e);
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "internal";
    }

    public function getExtensions(): array {
        return [
            "code" => "session_reinit_failed",
        ];
    }
}

