<?php

declare(strict_types=1);

use GraphQL\Validator\Rules\KnownArgumentNames;

/**
 * Known argument names
 *
 * A GraphQL field is only valid if all supplied arguments are defined by
 * that field.
 */
class MageQL_Core_Model_Validation_KnownArgumentNames extends KnownArgumentNames
{
    /**
     * @param string $argName
     * @param string $fieldName
     * @param string $typeName
     * @param string[] $suggestedArgs
     */
    public static function unknownArgMessage($argName, $fieldName, $typeName, array $suggestedArgs): string
    {
        return sprintf('Unknown argument "%s" on field "%s" of type "%s".', $argName, $fieldName, $typeName);
    }
}
