<?php

declare(strict_types=1);

use GraphQL\Validator\Rules\FieldsOnCorrectType;

class MageQL_Core_Model_Validation_FieldsOnCorrectType extends FieldsOnCorrectType
{
    /**
     * @param string   $fieldName
     * @param string   $type
     * @param string[] $suggestedTypeNames
     * @param string[] $suggestedFieldNames
     *
     * @return string
     */
    public static function undefinedFieldMessage(
        $fieldName,
        $type,
        array $suggestedTypeNames,
        array $suggestedFieldNames
    ) {
        return sprintf('Cannot query field "%s" on type "%s".', $fieldName, $type);
    }
}
