<?php

declare(strict_types=1);

/**
 * @template T as string
 */
abstract class MageQL_Core_Model_Customer_Result_Abstract {
    /**
     * @var T
     */
    protected $result;

    /**
     * @var ?Mage_Customer_Model_Customer
     */
    protected $customer;

    /**
     * @param T $result
     */
    public function __construct(
        string $result,
        Mage_Customer_Model_Customer $customer = null
    ) {
        $this->result = $result;
        $this->customer = $customer;
    }

    /**
     * @return T
     */
    public function getResult(): string {
        return $this->result;
    }

    public function getCustomer(): ?Mage_Customer_Model_Customer {
        return $this->customer;
    }
}
