<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;
use MageQL\Type\FieldBuilder;

/**
 * @template-extends MageQL_Core_Model_Attributes_Customer_Abstract<Mage_Customer_Model_Address_Abstract>
 * @psalm-suppress PropertyNotSetInConstructor
 */
class MageQL_Core_Model_Attributes_Customer_Address extends MageQL_Core_Model_Attributes_Customer_Abstract {
    protected function getEntityType(): string {
        return "customer_address";
    }

    public function getBaseAttributes(): array {
        return [
        ];
    }

    public function getFieldAttributeMap(): array {
        return [
            "street" => [
                "street",
            ],
            "country" => [
                "country_id",
            ],
            "region" => [
                "region",
                "region_id",
            ],
        ];
    }

    public function createFields(array $attributes): array {
        return array_merge(parent::createFields($attributes), [
            // TODO: Move these resolvers into this class
            "street" => new FieldBuilder(
                "[String!]!", "Street", [],
                [MageQL_Core_Model_Address::class, "resolveStreet"]
            ),
            "region" => new FieldBuilder(
                "AddressRegion", "Region", [],
                [MageQL_Core_Model_Address::class, "resolveRegion"]
            ),
            "country" => new FieldBuilder(
                "Country!", "Country", [],
                [MageQL_Core_Model_Address::class, "resolveCountry"]
            ),
        ]);
    }

    // Override to never have mandatory fields in return from address since it can always be empty
    public function createFieldBuilder(array $a): FieldBuilder {
        $a["required"] = false;

        return new FieldBuilder(
            $this->toGraphQLType($a), $a["label"], [],
            $this->getFieldResolver($a)
        );
    }

    public function createImageWrapper(
        $src,
        Context $ctx,
        ResolveInfo $info,
        string $attrCode,
        string $value
    ): MageQL_Core_Model_Attributes_Image_Abstract {
        throw new Exception(sprintf("%s: Not implemented", __METHOD__));
    }
}
