<?php

declare(strict_types=1);

class MageQL_Core_Helper_Address extends Mage_Core_Helper_Abstract {
    /**
     * Config path for allowed countries in the store,
     * see Mage_Directory_Model_Resource_Country_Collection::loadByStore.
     */
    const CONFIG_ALLOWED_COUNTRIES = "general/country/allow";

    /**
     * Returns a list of uppercase 2-letter country codes which are approved
     * for use in addresses for the store.
     *
     * @return Array<string>
     */
    public function getAllowedCountryCodes(Mage_Core_Model_Store $store): array {
        return array_map("strtoupper", array_filter(explode(",", $store->getConfig(self::CONFIG_ALLOWED_COUNTRIES) ?? "")));
    }
}
