<?php

declare(strict_types=1);

namespace MageQL\Core;

use Mage;
use Throwable;

use Spatie\Snapshots\MatchesSnapshots;
use PHPUnit\Framework\TestCase;
use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;

class FederationTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function testSdl(): void {
        $resp = MagentoManager::runRequest(new Request("GET /graphql?query=query{_service{sdl}}"));

        $data = json_decode($resp->getBody(), true);

        $this->assertArrayHasKey("data", $data);
        $this->assertEquals(["data"], array_keys($data));
        $this->assertArrayHasKey("_service", $data["data"]);
        $this->assertEquals(["_service"], array_keys($data["data"]));
        $this->assertArrayHasKey("sdl", $data["data"]["_service"]);
        $this->assertEquals(["sdl"], array_keys($data["data"]["_service"]));
        $this->assertMatchesSnapshot($data["data"]["_service"]["sdl"]);

        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));
    }
}
