<?php

namespace Fixtures;

use Mage;
use Mage_Core_Model_Store;
use Crossroads\Magento\Test\Integration\MagentoManager;

class Customer {
    public function load(): void {
        MagentoManager::init();

        /** @var Mage_Core_Model_Store $store */
        $store = Mage::app()->getStore(MagentoManager::TESTING_STORE);

        $this->createTestCustomer($store);
        $this->createDuplicateCustomer($store);
    }

    public function createTestCustomer(Mage_Core_Model_Store $store): void {
        // Reset the existing customer email
        $customer = Mage::getModel("customer/customer")
            ->setWebsiteId($store->getWebsiteId())
            ->loadByEmail("test@example.com");

        if($customer->getId()) {
            $customer
                ->setEmail("test-customer@example.com")
                ->save();
        }
        else {
            $customer = Mage::getModel("customer/customer")
                ->setWebsiteId($store->getWebsiteId())
                ->loadByEmail("test-customer@example.com");
        }

        $customer->addData([
            "email" => "test-customer@example.com",
            "website_id" => $store->getWebsiteId(),
            "store_id" => $store->getId(),
            "is_active" => 1,
            "force_confirmed" => 1,
            "firstname" => "Test",
            "lastname" => "Customer",
            "gender" => "Male",
        ]);
        $customer->setPassword("test-customer");
        $customer->save();

        foreach($customer->getAddresses() as $a) {
            $a->delete();
        }

        $billingAddress = Mage::getModel("customer/address");
        $shippingAddress = Mage::getModel("customer/address");

        $billingAddress->addData([
            "firstname" => "Test Firstname Billing",
            "lastname" => "Test Lastname Billing",
            "city" => "Test City Billing",
            "country_id" => "SE",
            "postcode" => "54321",
            "street" => "Test Street Billing",
            "telephone" => "0987654321",
            "vat_id" => "1337",
            "parent_id" => $customer->getId(),
            "is_default_billing" => 1,
            "is_default_shipping" => 0,
        ]);
        $shippingAddress->addData([
            "firstname" => "Test Firstname Shipping",
            "lastname" => "Test Lastname Shipping",
            "city" => "Test City Shipping",
            "country_id" => "SE",
            "postcode" => "12345",
            "street" => "Test Street Shipping\nSecond Street Shipping",
            "telephone" => "1234567890",
            "vat_id" => "1337",
            "parent_id" => $customer->getId(),
            "is_default_billing" => 0,
            "is_default_shipping" => 1,
        ]);

        $customer->addAddress($billingAddress);
        $customer->addAddress($shippingAddress);

        $billingAddress->save();
        $shippingAddress->save();

        $customer->save();
    }

    public function createDuplicateCustomer(Mage_Core_Model_Store $store): void {
        $customer = Mage::getModel("customer/customer");

        $customer->setWebsiteId($store->getWebsiteId());
        $customer->loadByEmail("test-duplicate@example.com");

        $customer->addData([
            "email" => "test-duplicate@example.com",
            "website_id" => $store->getWebsiteId(),
            "store_id" => $store->getId(),
            "is_active" => 1,
            "force_confirmed" => 1,
            "firstname" => "Test",
            "lastname" => "Duplicate",
        ]);
        $customer->setPassword("test-duplicate");

        $customer->save();
    }
}
