<?php

declare(strict_types=1);

namespace MageQL\Schema;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;
use MageQL\Type\FieldBuilder;
use MageQL\Type\InputFieldBuilder;

interface SchemaInterface {
    /**
     * If it knows the supplied type a type builder for the supplied
     * type is returned, otherwise null.
     */
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder;

    /**
     * Returns a map of the known fields for the supplied types, with
     * field-builders as values.
     *
     * @return Array<string, FieldBuilder|InputFieldBuilder>
     */
    public function getTypeFields(string $typeName, Registry $registry): array;

    /**
     * Returns a list of type-names implementing interfaces which will not be
     * reachable when traversing the types normally.
     *
     * @return Array<string>
     */
    public function getUnreachableTypes(): array;
}
