<?php

declare(strict_types=1);

namespace MageQL\Schema;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class DefaultSchema extends AbstractSchema {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "Query":
            return $this->object("Root query type.");
        case "Mutation":
            return $this->object("Root mutation type.");
        default:
            return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        return [];
    }
}
