<?php

declare(strict_types=1);

use GraphQL\Validator\Rules\KnownTypeNames;

/**
 * Known type names
 *
 * A GraphQL document is only valid if referenced types (specifically
 * variable definitions and fragment conditions) are defined by the type schema.
 */
class MageQL_Core_Model_Validation_KnownTypeNames extends KnownTypeNames
{
    /**
     * @param string   $type
     * @param string[] $suggestedTypes
     */
    public static function unknownTypeMessage($type, array $suggestedTypes): string
    {
        return sprintf('Unknown type "%s".', $type);
    }
}
