<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

use function MageQL\camelToSnakeCase;
use function MageQL\defaultVarienObjectResolver;

abstract class MageQL_Core_Model_Attributes_Image_Abstract {
    /**
     * @param array{width?:int, height?:int, fill?:bool} $args
     */
    public static function resolveSrc(
        MageQL_Core_Model_Attributes_Image_Abstract $src,
        array $args,
        Context $context,
        ResolveInfo $info
    ): string {
        return $src->getSrc($args, $context, $info);
    }

    /**
     * Resizes a given image, returning the URL to it.
     *
     * @param array{width?:int, height?:int, fill?:bool} $args
     */
    abstract public function getSrc(array $args, Context $context, ResolveInfo $info): string;
}
