<?php

declare(strict_types=1);

namespace MageQL;

use Mage_Core_Helper_Data;
use Mage_Core_Model_Session_Abstract_Varien;
use Mage_Core_Model_Store;

class Context {
    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;

    /**
     * @var Mage_Core_Model_Session_Abstract_Varien
     * @psalm-suppress PossiblyUnusedProperty
     */
    protected $session;

    /**
     * @var string
     */
    protected $schemaName;

    public function __construct(
        Mage_Core_Model_Store $store,
        Mage_Core_Model_Session_Abstract_Varien $session,
        string $schemaName
    ) {
        $this->store = $store;
        $this->session = $session;
        $this->schemaName = $schemaName;
    }

    public function getStore(): Mage_Core_Model_Store {
        return $this->store;
    }

    /**
     * @return mixed
     */
    public function getConfig(string $path) {
        return $this->store->getConfig($path);
    }

    public function getSchemaName(): string {
        return $this->schemaName;
    }

    public function getDefaultCountry(): string {
        // Always set
        return (string)$this->store->getConfig(Mage_Core_Helper_Data::XML_PATH_DEFAULT_COUNTRY);
    }

    public function stripBaseUrl(string $url): string {
        if( ! $url) {
            return $url;
        }

        $baseUrl = $this->store->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK, true);

        if(strpos($url, $baseUrl) === 0) {
            return "/".substr($url, strlen($baseUrl));
        }

        return $url;
    }
}
