<?php

class MageQL_Core_Model_Source_fieldSettingsSelector
{
    /**
     * Options getter.
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [];
        foreach ($this->toArray() as $key => $name) {
            $options[] = ['value' => $key, 'label' => $name];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format.
     * @return array
     */
    public function toArray(): array
    {
        $helper = Mage::helper('mageql/data');
        return [
            MageQL_Core_Model_Customer::FIELD_NORMAL => $helper->__('Visible and changeable'),
            MageQL_Core_Model_Customer::FIELD_READONLY => $helper->__('Visible only'),
            MageQL_Core_Model_Customer::FIELD_HIDDEN => $helper->__('Hidden'),
        ];
    }
    
}
