<?php

declare(strict_types=1);

use MageQL\Context;

/**
 * TODO: Replace with interface
 */
abstract class MageQL_Core_Model_Price_Abstract {
    abstract public function getExVat(Mage_Core_Model_Store $store): float;
    abstract public function getIncVat(Mage_Core_Model_Store $store): float;
    abstract public function getVat(Mage_Core_Model_Store $store): float;

    public static function resolveExVat(
        self $src,
        array $unusedArgs,
        Context $ctx
    ): float {
        return $src->getExVat($ctx->getStore());
    }

    public static function resolveIncVat(
        self $src,
        array $unusedArgs,
        Context $ctx
    ): float {
        return $src->getIncVat($ctx->getStore());
    }

    public static function resolveVat(
        self $src,
        array $unusedArgs,
        Context $ctx
    ): float {
        return $src->getVat($ctx->getStore());
    }
}
