<?php

namespace GraphQL\Type;

use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\SchemaConfig;

/**
 * @psalm-type SchemaConfigOptions = array{
 *   query?: MaybeLazyObjectType,
 *   mutation?: MaybeLazyObjectType,
 *   subscription?: MaybeLazyObjectType,
 *   types?: Types|null,
 *   directives?: array<Directive>|null,
 *   typeLoader?: TypeLoader|null,
 *   assumeValid?: bool|null,
 *   astNode?: SchemaDefinitionNode|null,
 *   extensionASTNodes?: array<SchemaExtensionNode>|null,
 * }
 * @psalm-type LazyObjectType ObjectType|(callable(): (ObjectType|null))|null
 */
class Schema
{
    /**
     * @param SchemaConfig|array{
     *   query?: LazyObjectType,
     *   mutation?: LazyObjectType,
     *   subscription?: LazyObjectType,
     *   types?: array<array-key, \GraphQL\Type\Definition\Type>|null,
     *   directives?: array<\GraphQL\Type\Definition\Directive>|null,
     *   typeLoader?: callable(string):\GraphQL\Type\Definition\Type|null,
     *   assumeValid?: bool|null,
     *   astNode?: \GraphQL\Language\AST\SchemaDefinitionNode|null,
     *   extensionASTNodes?: array<\GraphQL\Language\AST\SchemaExtensionNode>|null,
     * } $config
     */
    public function __construct($config) {}
}
