<?php declare(strict_types=1);

namespace GraphQL\Executor;

use GraphQL\Error\DebugFlag;

/**
 * @psalm-type SerializableResult array{
 *     data?: array<string, mixed>,
 *     errors?: list<array{
 *         message: string,
 *         locations?: array<int, array{line: int, column: int}>,
 *         path?: array<int, int|string>,
 *         extensions?: array<string, mixed>
 *     }>,
 *     extensions?: array<string, mixed>
 * }
 */
class ExecutionResult implements \JsonSerializable {
    /** @return SerializableResult */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(): array {}

    /** @return SerializableResult */
    public function toArray(int $debug = DebugFlag::NONE): array {}
}