<?php

declare(strict_types=1);

namespace MageQL\Type;

use function array_key_exists;

use MageQL\Registry;
use GraphQL\Type\Definition\Type;

/**
 * These wrappers exist to allow deferred creation of the underlying types.
 */
abstract class AbstractBuilder {
    /**
     * @var string
     */
    protected $description;

    public function __construct(string $description) {
        $this->description = $description;
    }

    public function getDescription(): ?string {
        return $this->description;
    }

    abstract public function createInstance(Registry $registry, string $typeName): Type;
}
