<?php

declare(strict_types=1);

namespace MageQL;

use Exception;

use GraphQL\Error\ClientAware;

class NotInstalledException extends Exception implements ClientAware {
    public function __construct() {
        parent::__construct("Magento store is not installed.");
    }

    public function isClientSafe(): bool {
        return false;
    }

    public function getCategory() {
        return "internal";
    }
}

