<?php

declare(strict_types=1);

use GraphQL\Validator\Rules\FieldsOnCorrectType;

class MageQL_Core_Model_Validation_FieldsOnCorrectType extends FieldsOnCorrectType
{
    /**
     * @param array<string> $suggestedTypeNames
     * @param array<string> $suggestedFieldNames
     */
    public static function undefinedFieldMessage(
        string $fieldName,
        string $type,
        array $suggestedTypeNames,
        array $suggestedFieldNames
    ): string {
        return sprintf('Cannot query field "%s" on type "%s".', $fieldName, $type);
    }
}
