<?php

declare(strict_types=1);

namespace MageQL\Type;
use function array_key_exists;

use MageQL\Registry;
use GraphQL\Type\Definition\Type;
use GraphQL\Type\Definition\EnumType;

class EnumBuilder extends AbstractBuilder {
    /**
     * @var Array<string, array{ description: string }>
     */
    protected $values;

    /**
     * @param Array<string, array{ description: string }> $values
     */
    public function __construct(string $description, array $values) {
        parent::__construct($description);

        $this->values = $values;
    }

    public function createInstance(
        Registry $registry,
        string $typeName
    ): Type {
        return new EnumType([
            "name" => $typeName,
            "description" => $this->description,
            "values" => $this->values,
        ]);
    }
}
