<?php

declare(strict_types=1);

namespace MageQL;

use function sprintf;

use GraphQL\Error\ClientAware;
use GraphQL\Error\Error;
use GraphQL\Error\ProvidesExtensions;

/**
 * Imitation of the Error reported by `GraphQL\Validator\Rules\KnownTypeNames`
 * but missing the location since it is not accessible while loading the type.
 *
 * `GraphQL\Schema::loadType` must be able to return `null` when using a
 * `typeLoader` which is currently (v0.13.5) not the case.
 */
class NotNullableTypeException extends TypeException implements ClientAware, ProvidesExtensions {
    public function __construct(string $typeName) {
        parent::__construct(sprintf("Cannot create a non-nullable type of \"%s\"", $typeName));
    }

    public function isClientSafe(): bool {
        return true;
    }

    public function getExtensions(): ?array {
        return [
            "category" => "graphql",
        ];
    }
}
