<?php

declare(strict_types=1);

namespace MageQL;

use Exception;
use GraphQL\Error\ClientAware;
use GraphQL\Error\ProvidesExtensions;

class NotInstalledException extends Exception implements ClientAware, ProvidesExtensions {
    public function __construct() {
        parent::__construct("Magento store is not installed.");
    }

    public function isClientSafe(): bool {
        return false;
    }

    public function getExtensions(): array {
        return [
            "category" => "internal",
        ];
    }
}

