<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use GraphQL\Utils\SchemaPrinter;
use MageQL\Context;
use MageQL\Schema\AbstractSchema;
use MageQL\Type\AbstractBuilder;
use MageQL\Registry;

class MageQL_Core_Model_Schema_Federation extends AbstractSchema {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "_Service":
            return $this->object("Object containing a Federation service specification for this service");

        default:
            return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "_Service":
            return [
                "sdl" => $this->field("String!", "String representation of the service schema")
                    ->setResolver([$this, "resolveSchemaText"]),
            ];

        case "Query":
            return [
                "_service" => $this->field("_Service!", "")
                    ->setResolver(function() {
                        return $this;
                    }),
            ];

        default:
            return [];
        }
    }

    /**
     * @param mixed $unusedSrc
     */
    public function resolveSchemaText(
        $unusedSrc,
        array $unusedArgs,
        Context $ctx
    ): string {
        // Include unreachable types to print all interface implementations but
        // skip Federation types to avoid collisions
        $schema = Mage::helper("mageql")->loadSchema($ctx, [
            "unreachable" => true,
            "federation" => false,
        ]);

        $sdl = SchemaPrinter::doPrint($schema, [
            "schemaDescriptions" => true,
            "sortArguments" => true,
            "sortEnumValues" => true,
            "sortFields" => true,
            "sortInputFields" => true,
            "sortTypes" => true,
        ]);

        return $sdl;
    }
}
