<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;
use GraphQL\Error\ProvidesExtensions;

class MageQL_Core_InvalidCountryCodeException
    extends Exception implements ClientAware, ProvidesExtensions {
    public function __construct(string $countryCode) {
        parent::__construct(sprintf(
            "The country code '%s' is invalid and cannot be assigned to an address.",
            $countryCode
        ));
    }

    public function isClientSafe(): bool {
        return true;
    }

    public function getExtensions(): array {
        return [
            "category" => "mageql",
        ];
    }
}
