<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;
use GraphQL\Error\ProvidesExtensions;

class MageQL_Core_InvalidAttributeOptionException
    extends Exception
    implements ClientAware, ProvidesExtensions {
    public function __construct(string $fieldName, string $optionValue) {
        parent::__construct(sprintf(
            "Option '%s' is invalid for field '%s'.",
            $optionValue,
            $fieldName
        ));
    }

    public function isClientSafe(): bool {
        return true;
    }

    public function getExtensions(): array {
        return [
            "category" => "mageql",
        ];
    }
}

