<?php

declare(strict_types=1);

use GraphQL\Error\ProvidesExtensions;

class MageQL_Core_Exception_SchemaNotFound
    extends MageQL_Core_Exception {
    public function __construct(string $schemaName) {
        parent::__construct(sprintf("Schema '%s' was not found.", $schemaName), 1001);
    }

    public function isClientSafe(): bool {
        return true;
    }

    public function getExtensions(): array {
        return [
            "category" => "schema",
        ];
    }
}
