<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;
use GraphQL\Error\ProvidesExtensions;

class MageQL_Core_Exception extends Exception implements ClientAware, ProvidesExtensions {
    public function __construct(string $message, int $code, Throwable $previous = null) {
        parent::__construct(sprintf("MageQL (%d): %s", $code, $message), $code, $previous);
    }

    public function isClientSafe(): bool {
        return false;
    }

    public function getExtensions(): array {
        return [
            "category" => "mageql",
        ];
    }
}
