<?php

declare(strict_types=1);

namespace MageQL;

class InactiveStoreException extends ClientException {
    public function __construct() {
        parent::__construct("Magento store is inactive.");
    }

    public function isClientSafe(): bool {
        return false;
    }

    public function getExtensions(): array {
        return [
            "category" => "internal",
            "code" => "store_inactive",
        ];
    }
}

