<?php

declare(strict_types=1);

namespace MageQL;

use RuntimeException;
use GraphQL\Error\ClientAware;
use GraphQL\Error\ProvidesExtensions;

/**
 * Client exception with extra extensions properties.
 */
abstract class ClientException extends RuntimeException implements ClientAware, ProvidesExtensions {
    /**
     * @deprecated Set category via ProvidesExtensions::getExtensions().
     */
    public final function getCategory(): string {
        return $this->isClientSafe() ? "client" : "internal";
    }

    /**
     * Override this method to provide extra extensions.
     * The category is automatically included from getCategory().
     *
     * @return Array<string, mixed>
     */
    public function getExtensions(): array {
        return [
            "category" => $this->isClientSafe() ? "client" : "internal",
        ];
    }
}
