<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

/**
 * @psalm-type ConfigurationOptionItem array{0:Mage_Catalog_Model_Product, 1:Array<Mage_Catalog_Model_Product_Type_Configurable_Attribute>}
 * @psalm-suppress PropertyNotSetInConstructor
 */
class MageQL_Sales_Model_Product extends Mage_Core_Model_Abstract {
    /**
     * Generates a buy request for a simple/virtual product.
     */
    public static function resolveBuyRequestSimple(
        Mage_Catalog_Model_Product $src,
        array $unusedArgs,
        Context $ctx
    ): ?string {
        $req = MageQL_Sales_Model_BuyRequest::fromProduct($src, $ctx->getStore());

        return $req ? (string)$req : null;
    }

    /**
     * Generates a buy request for a simple/virtual product custom option value.
     */
    public static function resolveBuyRequestSimpleCustomOption(
        Mage_Catalog_Model_Product_Option_Value $src
    ): ?string {
        $req = MageQL_Sales_Model_BuyRequest::fromProductOptionValue($src);

        return $req ? (string)$req : null;
    }

    /**
     * Generates a buy-request string for a configurable item which can be used
     * to add a product to a quote.
     */
    public static function resolveBuyRequestConfigItem(MageQL_Catalog_Model_Product_Configurable_Option $src): ?string {
        $req = MageQL_Sales_Model_BuyRequest::fromChildProduct($src);

        return $req ? (string)$req : null;
    }

    /**
     * Generates the basic buyRuquest for a bundle product to be completed with
     * options.
     */
    public static function resolveBuyRequestBaseBundle(
        Mage_Catalog_Model_Product $src
    ): MageQL_Sales_Model_BuyRequest_Product_Bundle {
        if($src->getTypeId() !== "bundle") {
            throw new Exception(sprintf(
                "%s: Requires bundle produc type, got '%s'.",
                __METHOD__,
                $src->getTypeId()
            ));
        }

        // We create an empty bundle buy-request
        return new MageQL_Sales_Model_BuyRequest_Product_Bundle($src, [], []);
    }
}
