<?php

declare(strict_types=1);

/**
 * Container for the list of attributes added on products loaded by
 * Mage_Sales_Model_Resource_Quote_Item_Collection.
 * @psalm-suppress PropertyNotSetInConstructor
 */
class MageQL_Sales_Model_Attributes_Product extends Mage_Core_Model_Abstract {
    /**
     * @var Array<string>
     */
    protected $attributes = [];

    /**
     * @param Array<string> $attributes
     */
    public function setQuoteAttributes(array $attributes): self {
        $this->attributes = $attributes;

        return $this;
    }

    public function getQuoteAttributes(Varien_Event_Observer $event): void {
        /**
         * @var Varien_Object
         */
        $toSelect = $event->getAttributes();

        foreach($this->attributes as $code) {
            // Magento looks in the list of keys on the Varien_Object
            $toSelect->setData($code, "");
        }
    }
}
