<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use function MageQL\snakeCaseToCamel;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_Sales_Model_Schema_Default_Payment extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        $paymentManager = MageQL_Sales_Model_Payment::instance(Mage::app()->getStore());

        switch($typeName) {
        case "MutationSetQuotePaymentMethod":
            return $this->object("Available payment methods to set");

        case "PaymentMethod":
            return $this->interface("Object representing a payment method")
                ->setTypeResolver([$paymentManager, "typePaymentMethod"]);

        case "QuotePayment":
            return $this->interface("Object containing data for the selected payment method")
                ->setTypeResolver([$paymentManager, "typeQuotePayment"]);
        }

        foreach($paymentManager->getModels() as $model) {
            $builder = $model->getTypeBuilder($typeName, $registry);

            if($builder) {
                return $builder;
            }
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        $paymentManager = MageQL_Sales_Model_Payment::instance(Mage::app()->getStore());

        switch($typeName) {
        case "PaymentMethod":
            return [
                // TODO: Is this actually useful?
                "code" => $this->field("ID!", "Payment method code"),
                "title" => $this->field("String!", "Payment method title"),
            ];

        case "Query":
            return [
                // TODO: Should be moved to quote probably
                "paymentMethods" => $this->field(
                    "[PaymentMethod!]!",
                    "List of enabled payment methods"
                )
                    ->setResolver(function(): array {
                        $methods = [];
                        $paymentHelper = Mage::helper("payment");
                        $quote = Mage::getSingleton("mageql_sales/quote")->getQuote();
                        $payment = $quote->getPayment();
                        $paymentRegistry = MageQL_Sales_Model_Payment::instance($quote->getStore());

                        // This function uses isAvailable on the instance
                        foreach($paymentHelper->getStoreMethods($quote->getStore(), $quote) as $method) {
                            if($method->canUseCheckout() &&
                                $paymentRegistry->hasPaymentMethod($method->getCode())) {
                                $method->setInfoInstance($payment);

                                $methods[] = $method;
                            }
                        }

                        return $methods;
                    }),
            ];

        case "QuotePayment":
            return [
                "code" => $this->field("ID!", "Payment code for the selected payment type")
                    ->setResolver("MageQL_Sales_Model_Quote_Payment::resolvePaymentCode"),
            ];
        }

        $fields = [];

        foreach($paymentManager->getModels() as $model) {
            $fields = array_merge($fields, $model->getTypeFields($typeName, $registry));
        }

        return $fields;
    }

    public function getUnreachableTypes(): array {
        $types = [];
        $paymentManager = MageQL_Sales_Model_Payment::instance(Mage::app()->getStore());

        foreach($paymentManager->getModels() as $model) {
            $types = array_merge($types, $model->getUnreachableTypes());
        }

        return $types;
    }
}
