<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class MageQL_Sales_Model_Order_Shipping extends Mage_Core_Model_Abstract {
    public static function resolveMethod(
        Mage_Sales_Model_Order $src
    ): Varien_Object {
        return new Varien_Object([
            "code" => $src->getShippingMethod(),
            "description" => $src->getShippingDescription(),
        ]);
    }

    public static function resolveTotal(
        Mage_Sales_Model_Order $src
    ): Varien_Object {
        return new Varien_Object([
            "inc_vat" => ($src->getShippingAmount() + $src->getShippingTaxAmount()),
            "ex_vat" => (float) $src->getShippingAmount(),
            "vat" => (float) $src->getShippingTaxAmount(),
        ]);
    }
}
