<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class MageQL_Sales_Model_Customer extends Mage_Core_Model_Abstract {
    /**
     * @param array{pageSize:int, page:int} $args
     */
    public static function resolveOrders(
        Mage_Customer_Model_Customer $src,
        array $args
    ): Mage_Sales_Model_Resource_Order_Collection {
        $orders = Mage::getResourceModel("sales/order_collection");

        $orders->addFieldToSelect("*");
        $orders->addFieldToFilter("customer_id", $src->getId());
        $orders->addFieldToFilter("state", ["in" => Mage::getSingleton("sales/order_config")->getVisibleOnFrontStates()]);
        $orders->setOrder("created_at", "desc");
        $orders->getSelect()->limitPage($args["page"], $args["pageSize"]);

        return $orders;
    }

    public static function resolvePaginatedItems(
        Mage_Sales_Model_Resource_Order_Collection $orders
    ): array {
        return $orders->getItems();
    }

    /**
     * @param mixed $unusedSrc
     */
    public static function resolveOrderById(
        $unusedSrc,
        array $args
    ): ?Mage_Sales_Model_Order {
        $customerSession = Mage::getSingleton("customer/session");
        $order = Mage::getModel("sales/order");

        if( ! $customerSession->isLoggedIn()) {
            return null;
        }

        $order->loadByIncrementId($args["id"]);

        if( ! $order->getId() || $order->getCustomerId() !== $customerSession->getCustomerId()) {
            return null;
        }

        return $order;
    }
}
