<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_Quote_Payment extends Mage_Core_Model_Abstract {
    /**
     * @return ?Mage_Sales_Model_Quote_Payment
     */
    public static function resolve(Mage_Sales_Model_Quote $src) {
        $paymentManager = MageQL_Sales_Model_Payment::instance($src->getStore());
        $payment = $src->getPayment();

        if( ! $payment->getMethod() || ! $paymentManager->hasPaymentMethod($payment->getMethod())) {
            return null;
        }

        return $payment;
    }

    public static function resolvePaymentCode(Mage_Sales_Model_Quote_Payment $src): string {
        return $src->getMethod();
    }
}
