<?php

declare(strict_types=1);

class MageQL_Sales_Model_Quote_Address_Result_Abstract {
    /**
     * @var string
     */
    protected $result;

    /**
     * @var ?Mage_Customer_Model_Address_Abstract
     */
    protected $address;

    /**
     * @param string $result
     */
    public function __construct(
        $result,
        Mage_Customer_Model_Address_Abstract $address = null
    ) {
        $this->result = $result;
        $this->address = $address;
    }

    /**
     * @return string
     */
    public function getResult(): string {
        return $this->result;
    }

    public function getAddress(): ?Mage_Customer_Model_Address_Abstract {
        return $this->address;
    }

    public function getValidationErrors(): ?array {
        if($this->address) {
            return MageQL_Core_Model_Address::resolveValidationErrors($this->address);
        }

        return [];
    }
}
