<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use function MageQL\snakeCaseToCamel;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;
use MageQL\Type\FieldBuilder;
use MageQL\Type\InterfaceBuilder;
use MageQL\Type\ObjectBuilder;

/**
 */
class MageQL_Sales_Model_Schema_Default_Discount extends MageQL_Core_Model_Schema_Abstract {

    public function __construct(array $args) {
        parent::__construct($args);
    }

    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {

        switch($typeName) {
        case "setQuoteDiscountCodeResult":
            return $this->object("Result from setQuoteDiscountCode");

        case "removeQuoteDiscountCodeResult":
            return $this->object("Result from removeQuoteDiscountCode");

        case "QuoteCoupon":
            return $this->object("Discount code information");

        case "QuoteDiscounts":
            return $this->object("Discount information");

        case "DiscountSum":
            return $this->object("Discount information");

        case "SetQuoteDiscountCodeResultType":
            return $this->enum(
                "Enum indicating status for adding discount code to quote",
                [
                    MageQL_Sales_Model_Discount::SUCCESS => [
                        "description" => "Successfully set discount code on quote",
                    ],
                    MageQL_Sales_Model_Discount::ERROR_CODE_EMPTY => [
                        "description" => "Discount code can not be empty",
                    ],
                    MageQL_Sales_Model_Discount::ERROR_CODE_NOT_FOUND => [
                        "description" => "Discount code was not found",
                    ],
                    MageQL_Sales_Model_Discount::ERROR_SETTING_CODE => [
                        "description" => "Error setting discount code on quote",
                    ],
                    MageQL_Sales_Model_Discount::ERROR_VALID_CODE_NOT_USABLE => [
                        "description" => "Code is valid but not usable with current cart content",
                    ]
                ]
            );

        case "RemoveQuoteDiscountCodeResultType":
            return $this->enum(
                "Enum indicating status for removing discount code from quote",
                [
                    MageQL_Sales_Model_Discount::SUCCESS => [
                        "description" => "Successfully removed discount code from quote",
                    ],
                    MageQL_Sales_Model_Discount::ERROR_REMOVING_CODE => [
                        "description" => "Error removing discount code from quote",
                    ],
                ]
            );

        case "DiscountType":
            return $this->enum(
                "Enum indicating status for removing discount code from quote",
                [
                    MageQL_Sales_Model_Discount::DISCOUNT_TYPE_NO_COUPON => [
                        "value" => Mage_SalesRule_Model_Rule::COUPON_TYPE_NO_COUPON,
                        "description" => "No coupon",
                    ],
                    MageQL_Sales_Model_Discount::DISCOUNT_TYPE_SPECIFIC => [
                        "value" => Mage_SalesRule_Model_Rule::COUPON_TYPE_SPECIFIC,
                        "description" => "Specific coupon",
                    ],
                    MageQL_Sales_Model_Discount::DISCOUNT_TYPE_AUTO => [
                        "value" => Mage_SalesRule_Model_Rule::COUPON_TYPE_AUTO,
                        "description" => "Multiple coupons",
                    ],
                ]
            );

        default:
            return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {

        switch($typeName) {
        case "Quote":
            return [
                "coupon" => $this->field("QuoteCoupon", "Applied discount code details")
                    ->setResolver("MageQL_Sales_Model_Discount::resolveDiscountCode"),
                "discountTotal" => $this->field("Float!", "Total of applied discounts")
                    ->setResolver("MageQL_Sales_Model_Discount::resolveDiscountTotal"),
                "discounts" => $this->field("[QuoteDiscounts!]", "Applied discount details")
                    ->setResolver("MageQL_Sales_Model_Discount::resolveDiscounts"),
            ];

        case "QuoteCoupon":
            return [
                "code" => $this->field("ID!", "Applied discount code"),
                "label" => $this->field("String!", "Discount description"),
            ];

        case "QuoteDiscounts":
            return [
                "label" => $this->field("String!", "Discount description"),
                "type" => $this->field("DiscountType!", "Discount type"),
            ];

        case "Mutation":
            return [
                "setQuoteDiscountCode" => $this->field("setQuoteDiscountCodeResult!", "Result of adding discount code")
                    ->addArgument("code", $this->argument("ID!", "Discount code to add"))
                    ->setResolver("MageQL_Sales_Model_Discount::mutateSetQuoteDiscountCode"),
                "removeQuoteDiscountCode" => $this->field("removeQuoteDiscountCodeResult!", "Result of removing discount code")
                    ->setResolver("MageQL_Sales_Model_Discount::mutateRemoveQuoteDiscountCode"),
            ];

        case "setQuoteDiscountCodeResult":
            return [
                "result" => $this->field("SetQuoteDiscountCodeResultType", "Status code of setQuoteDiscountCode")
                    ->setResolver("MageQL\\forwardResolver"),
                "coupon" => $this->field("QuoteCoupon", "Discount code details")
                    ->setResolver("MageQL_Sales_Model_Discount::resolveDiscountCode"),
            ];

        case "removeQuoteDiscountCodeResult":
            return [
                "result" => $this->field("RemoveQuoteDiscountCodeResultType", "Status code of removeQuoteDiscountCode")
                    ->setResolver("MageQL\\forwardResolver"),
            ];

        default:
            return [];
        }
    }

}
