<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_BuyRequest_Product extends MageQL_Sales_Model_BuyRequest {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * NOTE: Currently limited to just having a single custom option selected.
     *
     * @var ?Mage_Catalog_Model_Product_Option_Value
     */
    protected $customOption = null;

    public function __construct(
        Mage_Catalog_Model_Product $product,
        Mage_Catalog_Model_Product_Option_Value $value = null
    ) {
        $this->product = $product;
        $this->customOption = $value;
    }

    public function getProduct(): Mage_Catalog_Model_Product {
        return $this->product;
    }

    public function getBuyRequest(): array {
        $data = [];

        if($this->customOption) {
            $data["options"] = [
                (string)$this->customOption->getOptionId() => (string)$this->customOption->getId(),
            ];
        }

        return $data;
    }

    public function getPayload(): array {
        $data = [
            "p" => (int)$this->product->getId(),
        ];

        if($this->customOption) {
            $data["o"] = [
                (string)$this->customOption->getOptionId() => (string)$this->customOption->getId(),
            ];
        }

        return $data;
    }
}
