<?php

declare(strict_types=1);

namespace Fixtures;

use Mage;
use Mage_SalesRule_Model_Rule;
use Varien_Object;

use Crossroads\Magento\Test\Integration\MagentoManager;

class Discount {

    public function load(): void {
        MagentoManager::init();

        $this->clearDiscountRules();
        $this->addDiscountRules();

        MagentoManager::reset();
    }

    public function clearDiscountRules(): void {
        $sqlQuery = "DELETE FROM salesrule WHERE rule_id > 0";
        Mage::getSingleton("core/resource")->getConnection("core_write")->query($sqlQuery);
    }

    public function addDiscountRules(): void {
        $store = Mage::app()->getStore(MagentoManager::TESTING_STORE);
        $websiteId = $store->getWebsiteId();

        /*
         *  Add discount rule to allow 50% off of any product when using code "PHPUnitTest1"
         */
        $data1 = array(
            "product_ids" => null,
            "name" => "Test discount 1",
            "description" => "Auto generated",
            "is_active" => 1,
            "website_ids" => [$websiteId],
            "customer_group_ids" => [0,1],
            "coupon_type" => Mage_SalesRule_Model_Rule::COUPON_TYPE_SPECIFIC,
            "coupon_code" => "PHPUnitTest1",
            "uses_per_coupon" => 0,
            "uses_per_customer" => 0,
            "from_date" => date("Y-m-d"),
            "to_date" => date("Y-m-d", strtotime("+1 year")),
            "sort_order" => 0,
            "is_rss" => 0,
            "rule" => [
                "conditions" => [
                    1 => [
                        "type" => "salesrule/rule_condition_combine",
                        "attribute" => null,
                        "operator" => null,
                        "value" => "1",
                        "is_value_processed" => null,
                        "aggregator" => "all"
                    ]
                ],
                "actions" => [
                    1 => [
                        "type" => "salesrule/rule_condition_product_combine",
                        "attribute" => null,
                        "operator" => null,
                        "value" => "1",
                        "is_value_processed" => null,
                        "aggregator" => "all"
                    ]
                ]
            ],
            "simple_action" => "by_percent",
            "discount_amount" => 50,
            "discount_qty" => 0,
            "discount_step" => null,
            "apply_to_shipping" => 0,
            "simple_free_shipping" => 0,
            "stop_rules_processing" => 0,
            "store_labels" => ["Half off"]
        );

        $model1 = Mage::getModel('salesrule/rule');
        $validateResult1 = $model1->validateData(new Varien_Object($data1));
        if ($validateResult1 == true) {
            if (isset($data1['rule']['conditions'])) {
                $data1['conditions'] = $data1['rule']['conditions'];
            }
            if (isset($data1['rule']['actions'])) {
                $data1['actions'] = $data1['rule']['actions'];
            }
            unset($data1['rule']);
            $model1->loadPost($data1);
            $model1->save();
        }

        /*
         *  Add discount rule to allow 50% off of product "test-virtual" when using code "PHPUnitTest2"
         *  Also let rule trigger only if quote contains product "test-virtual"
         */
        $data2 = array(
            "product_ids" => null,
            "name" => "Test discount 2",
            "description" => "Auto generated",
            "is_active" => 1,
            "website_ids" => [$websiteId],
            "customer_group_ids" => [0,1],
            "coupon_type" => Mage_SalesRule_Model_Rule::COUPON_TYPE_SPECIFIC,
            "coupon_code" => "PHPUnitTest2",
            "uses_per_coupon" => 0,
            "uses_per_customer" => 0,
            "from_date" => date("Y-m-d"),
            "to_date" => date("Y-m-d", strtotime("+1 year")),
            "sort_order" => 0,
            "is_rss" => 0,
            "rule" => [
                "conditions" => [
                    1 => [
                        "type" => "salesrule/rule_condition_combine",
                        "attribute" => null,
                        "operator" => null,
                        "value" => "1",
                        "is_value_processed" => null,
                        "aggregator" => "all",
                        "conditions" => [
                            [
                                "type" => "salesrule/rule_condition_product_found",
                                "attribute" => null,
                                "operator" => null,
                                "value" => "1",
                                "is_value_processed" => null,
                                "aggregator" => "all",
                                "conditions" => [
                                    [
                                        "type" => "salesrule/rule_condition_product",
                                        "attribute" => "sku",
                                        "operator" => "==",
                                        "value" => "test-virtual",
                                        "is_value_processed" => false
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                "actions" => [
                    1 => [
                        [
                            "type" => "salesrule/rule_condition_product_combine",
                            "attribute" => null,
                            "operator" => null,
                            "value" => "1",
                            "is_value_processed" => null,
                            "aggregator" => "all",
                            "conditions" => [
                                [
                                    "type" => "salesrule/rule_condition_product",
                                    "attribute" => "sku",
                                    "operator" => "==",
                                    "value" => "test-virtual",
                                    "is_value_processed" => false
                                ]
                            ]
                        ]
                    ]
                ]
            ],
            "simple_action" => "by_percent",
            "discount_amount" => 50,
            "discount_qty" => 0,
            "discount_step" => null,
            "apply_to_shipping" => 0,
            "simple_free_shipping" => 0,
            "stop_rules_processing" => 0,
            "store_labels" => ["Half off special"]
        );

        $model2 = Mage::getModel('salesrule/rule');
        $validateResult2 = $model2->validateData(new Varien_Object($data2));
        if ($validateResult2 == true) {
            if (isset($data2['rule']['conditions'])) {
                $data2['conditions'] = $data2['rule']['conditions'];
            }
            if (isset($data2['rule']['actions'])) {
                $data2['actions'] = $data2['rule']['actions'];
            }
            unset($data2['rule']);
            $model2->loadPost($data2);
            $model2->save();

            /*
             *  Was unable to create correct rule by loadPost()
             *  Need to set actions_serialized "manually"
             */
            $ruleId = $model2->getId();
            $sqlQuery = "UPDATE salesrule SET actions_serialized = :data WHERE rule_id = :id";
            Mage::getSingleton("core/resource")->getConnection("core_write")->query($sqlQuery, ["data" => serialize($data2["actions"][1][0]), "id" => $ruleId]);
        }
    }

}
