<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use function MageQL\snakeCaseToCamel;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_Sales_Model_Schema_Default_Payment extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        $payment = Mage::getSingleton("mageql_sales/payment");

        switch($typeName) {
        case "MutationSetQuotePaymentMethod":
            return $this->object("Available payment methods to set");

        case "PaymentMethod":
            return $this->interface("Object representing a payment method")
                ->setTypeResolver([$payment, "typePaymentMethod"]);

        case "QuotePayment":
            return $this->interface("Object containing data for the selected payment method")
                ->setTypeResolver([$payment, "typeQuotePayment"]);
        }

        foreach($payment->getModels() as $model) {
            $builder = $model->getTypeBuilder($typeName, $registry);

            if($builder) {
                return $builder;
            }
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        $payment = Mage::getSingleton("mageql_sales/payment");

        switch($typeName) {
        case "PaymentMethod":
            return [
                // TODO: Is this actually useful?
                "code" => $this->field("ID!", "Payment method code"),
                "title" => $this->field("String!", "Payment method title"),
            ];

        case "Query":
            return [
                "paymentMethods" => $this->field(
                    "[PaymentMethod!]!",
                    "List of enabled payment methods"
                )
                    ->setResolver([$payment, "resolvePaymentMethods"]),
            ];

        case "QuotePayment":
            return [
                "code" => $this->field("ID!", "Payment code for the selected payment type")
                    ->setResolver("MageQL_Sales_Model_Quote_Payment::resolvePaymentCode"),
            ];
        }

        $fields = [];

        foreach($payment->getModels() as $model) {
            $fields = array_merge($fields, $model->getTypeFields($typeName, $registry));
        }

        return $fields;
    }

    public function getUnreachableTypes(): array {
        $types = [];
        $payment = Mage::getSingleton("mageql_sales/payment");

        foreach($payment->getModels() as $model) {
            $types = array_merge($types, $model->getUnreachableTypes());
        }

        return $types;
    }
}
