<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_BuyRequest_Product extends MageQL_Sales_Model_BuyRequest {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    public function __construct(Mage_Catalog_Model_Product $product) {
        $this->product = $product;
    }

    public function getProduct(): Mage_Catalog_Model_Product {
        return $this->product;
    }

    public function getBuyRequest(): array {
        return [];
    }

    public function getPayload(): array {
        return [
            "p" => (int)$this->product->getId(),
        ];
    }
}
