<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_BuyRequest_Item extends MageQL_Sales_Model_BuyRequest {
    /**
     * @var Mage_Sales_Model_Quote_Item
     */
    protected $item;

    public function __construct(Mage_Sales_Model_Quote_Item $item) {
        $this->item = $item;
    }

    public function getItem(): Mage_Sales_Model_Quote_Item {
        return $this->item;
    }

    public function getPayload(): array {
        return [
            "i" => (int) $this->item->getId(),
            "p" => (int) $this->item->getProductId(),
        ];
    }
}
